<?php

class multiexport extends Module
{

	function __construct()
	{
	
		global $cookie;
		$this->_cookie = $cookie;
		$this->name = 'multiexport';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		
		parent::__construct();
		
		$this->displayName = $this->l('Multi Export');
		$this->description = $this->l('Export your products in TXT or CSV file.');
		
	}

	function install()
	{
		if (!parent::install())
			return false;
		return true;
	}
	
    public function uninstall()
    {
		if (!parent::uninstall())
            return false;
        return true;
	}
	
	
	
	function getContent()
	{
	
		$lang=Configuration::get('PS_LANG_DEFAULT');
		set_time_limit(0);
	
				$this->_html = '<h2>'.$this->displayName.'</h2>';

			if (isset($_POST['submitFields']))
			{
			
						
				$this->_filename = $this->_directory.strtolower(Language::getIsoById($this->_cookie->id_lang)).'products'.$_POST['extension_fichier'];
				$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/multiexport/".strtolower(Language::getIsoById($this->_cookie->id_lang)).'products'.$_POST['extension_fichier'];
			
				$sep = $_POST['separateur'];
			
				// ------------- Dbut selection des sous-catgories ----------------------
				
				// Jusqu' 4 niveaux
				// Ex : Accueil -> Art de la table -> Boissons -> Bouilloire
				
				$sql1 = Db::getInstance()->Execute('
						SELECT id_category
						FROM '._DB_PREFIX_.'category
						WHERE id_parent = "'.$_POST['category'].'"
						');
				
				while($cat1=mysql_fetch_array($sql1))
				{
					$where .= ' OR cp.id_category = "'.$cat1['id_category'].'"';
					
					$sql2 = Db::getInstance()->Execute('
							SELECT id_category
							FROM '._DB_PREFIX_.'category
							WHERE id_parent = "'.$cat1['id_category'].'"
							');
					
					while($cat2=mysql_fetch_array($sql2))
					{
						$where .= ' OR cp.id_category = "'.$cat2['id_category'].'"';
						
						$sql3 = Db::getInstance()->Execute('
								SELECT id_category
								FROM '._DB_PREFIX_.'category
								WHERE id_parent = "'.$cat2['id_category'].'"
								');
						
						while($cat3=mysql_fetch_array($sql3))
						{
							$where .= ' OR cp.id_category = "'.$cat3['id_category'].'"';
						}
					}
				}
				
				// ------------- Fin selection des sous-catgories ----------------------
				
				$link = new Link();
				
				$sql = Db::getInstance()->Execute('
						SELECT p.* , pl.* , m.name AS manufacturer_name, s.name AS supplier_name, t.rate, sp.reduction, sp.reduction_type, sp.from, sp.to
						FROM '._DB_PREFIX_.'product AS p

						LEFT JOIN '._DB_PREFIX_.'category_product AS cp ON p.id_product = cp.id_product
						LEFT JOIN '._DB_PREFIX_.'product_lang AS pl ON p.id_product = pl.id_product
						LEFT JOIN '._DB_PREFIX_.'manufacturer AS m ON p.id_manufacturer = m.id_manufacturer
						LEFT JOIN '._DB_PREFIX_.'supplier AS s ON p.id_supplier = s.id_supplier
						LEFT JOIN '._DB_PREFIX_.'tax AS t ON p.id_tax_rules_group = t.id_tax
						LEFT JOIN '._DB_PREFIX_.'specific_price AS sp ON p.id_product = sp.id_product

						WHERE (cp.id_category = "'.$_POST['category'].'"'.$where.')
						AND pl.id_lang = '.$_POST['language'].'
						');
						
				if($_POST['destination'] == 'amazon')
				{
					$file .= '"sku"'.$sep;
					$file .= '"product-id"'.$sep;
					$file .= '"product-id-type"'.$sep;
					$file .= '"price"'.$sep;
					$file .= '"item-condition"'.$sep;
					$file .= '"quantity"'.$sep;
					$file .= '"add-delete"'.$sep;
					$file .= '"will-ship-internationally"'.$sep;
					$file .= '"expedited-shipping"'.$sep;
					$file .= '"item-note"'.$sep;
					$file .= '"Fulfillment-center-id"';

					$file .= "\n";
				}
				else{
					$file .= '"id_product"'.$sep;
					$file .= '"active"'.$sep;
					$file .= '"name"'.$sep;
					$file .= '"category_default"'.$sep;
					$file .= '"priceHT"'.$sep;
					$file .= '"id_tax"'.$sep;
					$file .= '"priceHTAchat"'.$sep;
					$file .= '"on_sale"'.$sep;
					$file .= '"reduction"'.$sep;
					$file .= '"reduction_type"'.$sep;

					$file .= '"from"'.$sep;
					$file .= '"to"'.$sep;
					$file .= '"reference"'.$sep;
					$file .= '"supplier_reference"'.$sep;
					$file .= '"id_supplier"'.$sep;
					$file .= '"id_manufacturer"'.$sep;
					$file .= '"ean13"'.$sep;
					$file .= '"upc"'.$sep;
					$file .= '"ecotax"'.$sep;
					$file .= '"weight"'.$sep;
					$file .= '"quantity"'.$sep;
					$file .= '"description_short"'.$sep;
					$file .= '"description"'.$sep;
					$file .= '"tags"'.$sep;
					$file .= '"meta_title"'.$sep;
					$file .= '"meta_keywords"'.$sep;
					$file .= '"meta_description"'.$sep;
					$file .= '"link_rewrite"'.$sep;
					$file .= '"available_now"'.$sep;
					$file .= '"available_latter"'.$sep;
					$file .= '"image_link"'.$sep;
					$file .= '"suppr_images"'.$sep;
					$file .= '"carac"'.$sep;
					$file .= '"online_only"'.$sep;
					$file .= '"condition"'.$sep;
					$file .= '"id_color_default"'.$sep;
					$file .= '"location"'.$sep;
					$file .= '"out_of_stock"'.$sep;
					$file .= '"quantity_discount"'.$sep;
					$file .= '"customizable"'.$sep;
					$file .= '"uploadable_files"'.$sep;
					$file .= '"text_fields"'.$sep;
					$file .= '"indexed"'.$sep;
					$file .= '"date_add"'.$sep;
					$file .= '"date_upd"'.$sep;
					$file .= '"product_link"'.$sep;
					$file .= '"manufacturer_name"'.$sep;
					$file .= '"tax_rate"'.$sep;
					$file .= '"supplier_name"';
					$file .= "\n";
				}
				
				$i=0;
				while($Product=mysql_fetch_array($sql))
				{
					$lesTags = '';
					
					$sqlTags = Db::getInstance()->Execute('
						SELECT name
						FROM '._DB_PREFIX_.'product_tag AS pt
						LEFT JOIN '._DB_PREFIX_.'tag AS t ON pt.id_tag = t.id_tag
						WHERE pt.id_product = "'.$Product['id_product'].'"
						');
					while($tags=mysql_fetch_array($sqlTags))
					{
						$lesTags .= $tags['name'].',';
					}
						
					if($_POST['add_html']==1)
					{
						$Product['description']=html_entity_decode(strip_tags(str_replace('"','""',$Product['description'])));
						$Product['description_short']=html_entity_decode(strip_tags(str_replace('"','""',$Product['description_short'])));
					}
			
					$image = Image::getImages(intval($this->_cookie->id_lang), $Product['id_product']);
	
					if($_POST['destination'] == 'amazon')
					{
						$file .= '"'.$Product['reference'].'"'.$sep;
						$file .= '"'.$Product['ean13'].'"'.$sep;
						$file .= '"4"'.$sep;
						$file .= '"'.number_format(($Product['price']+($Product['price']*($Product['rate']/100))), 2, ',', '').'"'.$sep;
						$file .= '"11"'.$sep;
						$file .= '"'.$Product['quantity'].'"'.$sep;
						$file .= '"a"'.$sep;
						$file .= '"16"'.$sep;
						$file .= '"15"'.$sep;
						$file .= '""'.$sep;
						$file .= '"DEFAULT"';

						$file .= "\n";
					}
					else{
						$file .= '""'.$sep;
						$file .= '"'.$Product['active'].'"'.$sep;
						$file .= '"'.str_replace('"','""',$Product['name']).'"'.$sep;
						$file .= '"'.$Product['id_category_default'].'"'.$sep;
						$file .= '"'.$Product['price'].'"'.$sep;
						$file .= '"'.$Product['id_tax_rules_group'].'"'.$sep;
						$file .= '"'.$Product['wholesale_price'].'"'.$sep;
						$file .= '"'.$Product['on_sale'].'"'.$sep;
						$file .= '""'.$sep;
						$file .= '""'.$sep;
						$file .= '"'.$Product['from'].'"'.$sep;
						$file .= '"'.$Product['to'].'"'.$sep;
						$file .= '"'.$Product['reference'].'"'.$sep;
						$file .= '"'.$Product['supplier_reference'].'"'.$sep;
						$file .= '"'.$Product['id_supplier'].'"'.$sep;
						$file .= '"'.$Product['id_manufacturer'].'"'.$sep;
						$file .= '"'.$Product['ean13'].'"'.$sep;
						$file .= '"'.$Product['upc'].'"'.$sep;
						$file .= '"'.$Product['ecotax'].'"'.$sep;
						$file .= '"'.$Product['weight'].'"'.$sep;
						$file .= '"'.$Product['quantity'].'"'.$sep;
						$file .= '"'.str_replace('"','""',utf8_encode($Product['description_short'])).'"'.$sep;
						$file .= '"'.str_replace('"','""',utf8_encode($Product['description'])).'"'.$sep;
						$file .= '"'.$lesTags.'"'.$sep;
						$file .= '"'.str_replace('"','""',$Product['meta_title']).'"'.$sep;
						$file .= '"'.str_replace('"','""',$Product['meta_keywords']).'"'.$sep;
						$file .= '"'.str_replace('"','""',$Product['meta_description']).'"'.$sep;
						$file .= '"'.$Product['link_rewrite'].'"'.$sep;
						$file .= '"'.$Product['available_now'].'"'.$sep;
						$file .= '"'.$Product['available_later'].'"'.$sep;
						$file .= '"http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'img/p/'.$image[0]['id_product'].'-'.$image[0]['id_image'].'-large.jpg"'.$sep;
						$file .= '"0"'.$sep;
						$file .= '"'.$Product['online_only'].'"'.$sep;
						$file .= '""'.$sep;
						$file .= '"'.$Product['condition'].'"'.$sep;
						$file .= '"'.$Product['id_color_default'].'"'.$sep;
						$file .= '"'.$Product['location'].'"'.$sep;
						$file .= '"'.$Product['out_of_stock'].'"'.$sep;
						$file .= '"'.$Product['quantity_discount'].'"'.$sep;
						$file .= '"'.$Product['customizable'].'"'.$sep;
						$file .= '"'.$Product['uploadable_files'].'"'.$sep;
						$file .= '"'.$Product['text_fields'].'"'.$sep;
						$file .= '"'.$Product['indexed'].'"'.$sep;
						$file .= '"'.$Product['date_add'].'"'.$sep;
						$file .= '"'.$Product['date_upd'].'"'.$sep;
						$file .= '"'.htmlspecialchars($link->getProductLink($Product['id_product'], $Product['link_rewrite'])).'"'.$sep;
						$file .= '"'.$Product['manufacturer_name'].'"'.$sep;
						$file .= '"'.$Product['rate'].'"'.$sep;
						$file .= '"'.$Product['supplier_name'].'"';
						$file .= "\n";
					}
					
					$i++;
				}
				
				
				$fp = fopen('../modules/multiexport/'.$this->_filename, 'w');
				fwrite($fp, $file);
				fclose($fp);
				
				if(file_exists('../modules/multiexport/'.$this->_filename))
				{
					$fp = fopen('../modules/multiexport/'.$this->_filename, 'rb');
					$fstat = fstat($fp);
					fclose($fp);
					
					$this->_html .= '<div class="conf confirm">
						<img src="../img/admin/ok.gif" alt="" title="" />
				  <p>'.$this->l('Your Products file is online at the following address:').'<br /><a href="'.$this->_filename_http.'" target="_blanck"><b>'.$this->_filename_http.'</b></a></p><br />';
					$this->_html .= $this->l('Update:').' <b>'.$i.$this->l(' products from category ').$_POST['category'].' on '.date('m.d.y G:i:s', $fstat['mtime']).'</b><br /></div>';
				}
		
			}
			$this->_html.='
			<fieldset class="width3" style="width:900px;">
				<legend><img src="../img/admin/asterisk.gif" />'.$this->l('Infos on the exported fields').'</legend>
					<p>'.$this->l('Ce module exporte vos cat&eacutegories sur 4 niveaux.').'</p>
					<br>'.$this->l('Pour ouvrir votre  CSV : Choisir UTF8 encodage').'<br>
					<br>'.$this->l('Les Champs peuvent etre separ&eacutes par , ; | ou une tabulation').'<br>
					<br>'.$this->l('Les Textes sont separ&eacutes par les double quotes (" ")').'<br>
				
					
			</fieldset><br><br>';
			
			$this->_displayForm();
	
			
			return $this->_html;
		
	
	}

	private function _displayForm()
	{
         $this->_html .= '<script language = "javascript">
         function tick(desti)
         {
             if(desti == "presta")
             {
                document.formulaire.add_html[0].checked = true;
                document.formulaire.separateur[1].checked = true;
                document.formulaire.extension_fichier[0].selected = true;
                document.formulaire.destination[0].selected = true;
             }
             else if(desti == "amazon")
             {
                document.formulaire.add_html[0].checked = true;
                document.formulaire.separateur[3].checked = true;
                document.formulaire.extension_fichier[1].selected = true;
                document.formulaire.destination[1].selected = true;
             }
         }
         </script>';
		 
		$this->_html .= '<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
		<form method="post" name="formulaire">';
		
		$this->_html .= $this->l('Export pour').' <a href="#" onClick="tick(\'presta\')">Prestashop</a> / <a href="#" onClick="tick(\'amazon\')">Amazon</a><br><br><label style="text-align: left">'.$this->l('Supprimer TAG HTML ?').' </label>
				<div class="margin-form">
					<input type="radio" name="add_html" id="add_html_yes" value="1"  '.(isset($_POST['add_html']) AND $_POST['add_html']==1 ? 'checked="checked"' : '').' />
					<label class="t" for="add_html_yes"><img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Yes').'" /></label>
					<input type="radio" name="add_html" id="add_html_no" value="0" '.(isset($_POST['add_html']) AND $_POST['add_html']==0 ? 'checked="checked"' : '').'  />
					<label class="t" for="add_html_no"><img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('No').'" /></label>
					</div><table style="text-align: left; width: 900px;"><tr><td>
          <span style="font-weight: bold; color: rgb(153, 0, 0);">'.$this->l('Choisissez la cat&eacutegorie a exporter :').'<br><br></span></td>
		  <td><select name="category">';
		  
			  $categories = Category::getCategories(intval($this->_cookie->id_lang), false);
			  @$this->recurseCategory($categories, $categories[0][1], 1);
		
		  $this->_html .= '<select><br><br></td>
		  </tr>';
		  
		  $langue = LanguageCore::getLanguages(false);
		  
		  $this->_html .= '<tr><td>
          <span style="font-weight: bold; color: rgb(153, 0, 0);">'.$this->l('Choisissez la langue :').'<br><br></span></td>
		  <td><select name="language">';
			  
		  foreach($langue AS $lg){
			if($lg['id_lang'] == $this->_cookie->id_lang)
				$select = 'selected';
			else
				$select = '';
			
			$this->_html .= '<option value="'.$lg['id_lang'].'" '.$select.'>'.$lg['name'].'</option>';
		  }
			  
		  $this->_html .= '<select><br><br></td>
		  </tr>
		  <tr>
	       <td>Extensions Fichier
	       <select name="extension_fichier">
	       <option value=".csv" id="excsv">.csv</option>
	       <option value=".txt" id="extxt">.txt</option>
	       </select>
		   </td>
		   <td>
			<input  type="radio" name="separateur" id="vir" value=",">  	Virgule ","
			<input  type="radio" name="separateur" id="ptvir" value=";" checked="checked">  	Point-Virgule ";"
			<input  type="radio" name="separateur" id="pipe" value="|">  	Pipe "|"
			<input  type="radio" name="separateur" id="tabu" value="	">	Tabulation "	"
			</td>
		   </tr>
		   <br>
		   <tr>
	       <td><br>Organisation des colonnes pour  
	       <select name="destination">
	       <option value="all" id="atall">Prestashop</option>
	       <option value="amazon" id="atamazon">Amazon</option>
	       </select>
		   </td>
		   </tr>
		   </table>
		  <br><br><center><input type="submit" name="submitFields" value="'.$this->l('Export').'" style="font-weight:bold;width: 180px;"/></center>';
	
		$this->_html .= '</form></fieldset>';
		
	
	}

	public function recurseCategory($categories, $current, $id_category = 1, $id_selected = 1)
	{
		$this->_html .= '<option value="'.$id_category.'"'.(($id_selected == $id_category) ? ' selected="selected"' : '').'>'.
		str_repeat('&nbsp;', $current['infos']['level_depth'] * 5).stripslashes($current['infos']['name']).'</option>';
		if (isset($categories[$id_category]))
			foreach ($categories[$id_category] AS $key => $row)
				self::recurseCategory($categories, $categories[$id_category][$key], $key, $id_selected);
	}

}