<?php
/**
 * Protect your templates
 *
 * @category Prestashop
 * @category Module
 * @author Samdha <contact@samdha.net>
 * @copyright Samdha
 * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
 * @version 1.0
 * @license logo http://www.gnu.org/copyleft/gpl.html GPL
 * @see logo http://icones.pro/diabolique-visage-image-png.html
**/

class emptyCache extends Module
{
	private $cacheDirs = array();

	function __construct()
	{
	 	$this->name = 'emptycache';
	 	$this->tab = version_compare(_PS_VERSION_, '1.4.0.0', '<')?'Tools':'administration';
	 	$this->version = '1.0';

	 	parent::__construct();

	 	/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Empty cache');
		$this->description = $this->l('Allows you to clean Prestashop cache');
		$this->author = 'Samdha';
		$this->cacheDirs = array(
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'tools'.DIRECTORY_SEPARATOR.'smarty'.DIRECTORY_SEPARATOR.'compile',
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'tools'.DIRECTORY_SEPARATOR.'smarty'.DIRECTORY_SEPARATOR.'cache',
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'tools'.DIRECTORY_SEPARATOR.'smarty_v2'.DIRECTORY_SEPARATOR.'cache',
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'tools'.DIRECTORY_SEPARATOR.'smarty_v2'.DIRECTORY_SEPARATOR.'cache',
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'tools'.DIRECTORY_SEPARATOR.'cache',
			_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'img'.DIRECTORY_SEPARATOR.'tmp'
		);
	}
	
	public function install()
	{
		return (parent::install()
				&& Configuration::updateValue($this->name, Tools::passwdGen())
				&& $this->registerHook('header'));
	}

	public function uninstall()
	{
		return (Configuration::deleteByName($this->name)
				&& parent::uninstall());
	}

	public function getContent($tab = 'AdminModules') {
		global $currentIndex, $cookie;
		$token = Tools::getAdminToken($tab.intval(Tab::getIdFromClassName($tab)).intval($cookie->id_employee));

		$this->_postProcess($token);
        $output = '<h2>'.$this->displayName.'</h2>';
        $output .= $this->_displayForm($token);

		return $output;
    }

	private function _displayForm($token) {
		global $currentIndex;
		$customer_cookie = new Cookie('ps');
		
		$output = '
			<fieldset style="float: right; width: 255px">
				<legend>'.$this->l('About').'</legend>
				<p style="font-size: 1.5em; font-weight: bold; padding-bottom: 0"><img src="'.$this->_path.'logo.png" alt="'.$this->displayName.'" style="float: left; padding-right: 1em"/><a href="http://www.commerce-connector.com">'.$this->displayName.'</a></p>
				<p style="clear: both">
				'.$this->l('Thanks for installing this module on your website.').'
				</p>
				<p>
				'.$this->l('Developped with love by').' <a style="color: #7ba45b; text-decoration: underline;" href="http://www.samdha.net">Samdha</a>'.$this->l(', which helps you develop your e-commerce site.').'
				</p>
				<p>
				<a href="http://www.samdha.net/contactez-nous"><img src="../img/admin/email.gif" alt="" /> '.$this->l('Contact').'</a>
				</p>
			</fieldset>
			<form action="'.$currentIndex.'&amp;configure='.$this->name.'&amp;token='.$token.'" method="post">
				<fieldset class="width3 space">
					<legend>'.$this->l('Informations').'</legend>
					<p>
					'.$this->l('This module allows you to clean Prestashop cache.').'
					</p>
					<p>
					'.$this->l('Caching is used to speed up the display of page by saving its output to a file. If a cached version of the page is available, that is displayed instead of regenerating the output. Caching can speed things up tremendously but when you are working on your shop design or updating a module it\'s very annoying.').'
					</p>
					<p>
						<input type="submit" class="button" name="cleanCache" value="'.$this->l('Empty cache').' ('.$this->HumanReadableFilesize($this->getCacheSize()).')" />';
		if ($customer_cookie->{$this->name} == Configuration::get($this->name))
			$output .= '&nbsp;<input type="submit" class="button" name="hideIcon" value="'.$this->l('Remove icon from frontoffice').'" />';
		else
			$output .= '&nbsp;<input type="submit" class="button" name="showIcon" value="'.$this->l('Show icon in frontoffice').'" />';
		$output .= '
					</p>
				</fieldset>
			</form>
			<br class="clear"/>
		';
		return $output;
	}

	private function _postProcess($token) {
		global $currentIndex;

		if (Tools::isSubmit('cleanCache')) {
			$this->emptyTheCache();
			Tools::redirectAdmin($currentIndex.'&configure='.$this->name.'&conf=1&token='.$token);
		}
		if (Tools::isSubmit('showIcon')) {
			$customer_cookie = new Cookie('ps');
			$customer_cookie->{$this->name} = Configuration::get($this->name);
			Tools::redirectAdmin($currentIndex.'&configure='.$this->name.'&conf=6&token='.$token);
		}
		if (Tools::isSubmit('hideIcon')) {
			$customer_cookie = new Cookie('ps');
			unset($customer_cookie->{$this->name});
			Tools::redirectAdmin($currentIndex.'&configure='.$this->name.'&conf=6&token='.$token);
		}
	}
		
	public function hookHeader($params) {
		global $cookie, $smarty, $link;
		if ($cookie->{$this->name} == Configuration::get($this->name)) {
			if (Tools::getValue($this->name)) {
				$this->emptyTheCache();
				Tools::redirectAdmin($this->getUrlWithOut($this->name));
			}
			$smarty->assign(array(
				'url' => $link->getUrlWith($this->name, '1'),
				'cacheSize' => $this->HumanReadableFilesize($this->getCacheSize()),
				'this_path' => $this->_path
			));
			
			return $this->display(__FILE__, $this->name.'.tpl');
		}
	}
	
	private function emptyTheCache() {
		foreach($this->cacheDirs as $dir)
			if (file_exists($dir))
				$this->emptydir($dir);
	}
	
	private function getCacheSize() {
		$size = 0;
		foreach($this->cacheDirs as $dir) {
			$size += $this->dirsize($dir);
		}
		return $size;
	}
	
	/** Usefull functions **/

	/**
	 * return the current url without a parameter
	 * @see Link::getUrlWith
	 *
	 * @param string $key the parameter
	 * @return string
	 **/
	public function getUrlWithOut($key)
	{
		$n = 0;
		$url = htmlentities($_SERVER['SCRIPT_NAME'], ENT_QUOTES, 'UTF-8');
		
		foreach ($_GET as $k => $value)
			// adminlang is an hand-written param in BO
			if ($k != 'adminlang')
				if (!is_array($value) AND $k != $key AND Tools::isSubmit($k))
					$url .= ((!$n++) ? '?' : '&amp;').urlencode($k).($value ? '='.urlencode($value) : '');
		
		return $url;
	}
	
	/**
	 * Returns a human readable filesize
	 *
	 * @author      wesman20 (php.net)
	 * @author      Jonas John
	 * @version     0.3
	 * @link        http://www.jonasjohn.de/snippets/php/readable-filesize.htm
	 */
	function HumanReadableFilesize($size) {

		// Adapted from: http://www.php.net/manual/en/function.filesize.php

		$mod = 1024;

		$units = explode(' ','B KB MB GB TB PB');
		for ($i = 0; $size > $mod; $i++) {
			$size /= $mod;
		}

		return round($size, 2) . ' ' . $units[$i];
	}

	// http://www.php.net/manual/fr/function.rmdir.php#98622
	private function emptydir($dir) {
		if (is_dir($dir)) {
			$objects = scandir($dir);
			foreach ($objects as $object)
				if ($object != "." && $object != ".." && $object != 'index.php')
					if (filetype($dir."/".$object) == "dir")
						$this->emptydir($dir."/".$object);
					else
						@unlink($dir."/".$object);
			reset($objects);
		}
	}

	private function dirsize($dir) {
		$size = 0;
		if (is_dir($dir)) {
			$objects = scandir($dir);
			foreach ($objects as $object)
				if ($object != "." && $object != ".." && $object != 'index.php')
					if (filetype($dir."/".$object) == "dir")
						$size += $this->dirsize($dir."/".$object);
					else
						$size += filesize($dir."/".$object);
			reset($objects);
		}
		return $size;
	}

}
?>
