<?php
/**	
 *	domMessageCategory : Module pour site sous PrestaShop.
 *	Affiche un message lors de la consultation d'une catégorie.
 *	
 *	Version	2.1
 *
 *	Copyright Dominique PAUL.
 * 	Site de l'auteur : http://www.aideaunet.com
 *  
 *	Les scripts PHP de ce module sont sous Copyright.
 *  La modification des scripts de ce module est strictement INTERDITE.
 *
 *  Seules les scripts TPL (scripts de thèmes) et CSS (feuilles de style) sont autorisés à modification.
 *
 * 	Ce module est en téléchargement libre sur le site de l'auteur,
 * 	La distribution de ce module est INTERDITE sur tout autre support sans accord préalable de l'auteur.
 *
 **/
 
// Securité
if (!defined('_PS_VERSION_'))
	exit;
	
error_reporting(E_ERROR);
	
class DomMessageCategory extends Module
{
	private $_pageHtml = '';
	private $editInProgress=0;
	private $ErrorAdd=0;
	
	public function __construct() {
		$this->name = 'dommessagecategory';
    if(_PS_VERSION_<'1.4')
			$this->tab = $this->l('created or adapted by Domi');
		else
			$this->tab = 'front_office_features';
    $this->version = 2.1;
    $this->author = 'Dominique PAUL';
		$this->siteauthor = 'www.aideaunet.com';

		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		if(_PS_VERSION_<'1.4') {
			$this->displayName = $this->l('Created Domi : Category messages.').' NOT COMPATIBLE';
			$this->description = $this->l('Module is not compatible Prestashop ')._PS_VERSION_;
		} else {
			$this->displayName = $this->l('Category messages');
			$this->description = $this->l('Enable messages or advertising on category.');
		}
		if (!$this->hookHeader($params)) $this->registerHook('header');
		if (Configuration::get('MOD_DOMPAGECATEGORY_VERSION') < $this->version && Configuration::get('MOD_DOMPAGECATEGORY_VERSION') <> 0) {
			$this->majb2d();
		}
	}

	public function install() {
		if(_PS_VERSION_<'1.4') return false;
		if(!parent::install() || 
		   !$this->registerHook('header') || 
		   !$this->registerHook('top') || 
		   !Configuration::updateValue('MOD_DOMPAGECATEGORY_ACTIVE', 'on') ||
		   !Configuration::updateValue('MOD_DOMPAGECATEGORY_VERSION', $this->version) ||
		   !$this->installModuleTab('AdminDomMessageCategory', array(1=>'DomMessageCategory', 2=>'DomMessageCategory', 3=>'DomMessageCategory', 4=>'DomMessageCategory', 5=>'DomMessageCategory'), 7) ||
		   !$this->installDB())
			return false;
		else
			return true;
	}
	
	private function installModuleTab($tabClass, $tabName, $idTabParent) {
    @copy(_PS_MODULE_DIR_.$this->name.'/logo.gif', _PS_IMG_DIR_.'t/'.$tabName.'.gif');
    $tab = new Tab();
    $tab->name = $tabName;
    $tab->class_name = $tabClass;
    $tab->module = $this->name;
    $tab->id_parent = $idTabParent;
    if(!$tab->save())
      return false;
    return true;
  }

	public function installDb() {
		Db::getInstance()->ExecuteS('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'dommessage_page` (
		  `id_page` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		  `name` VARCHAR(50) NOT NULL,
		  `display` VARCHAR(10) NULL,
		  `viecookieheure` INT NOT NULL DEFAULT 24,
		  `viecookieminute` INT NOT NULL DEFAULT 0,
		  `mode` VARCHAR(10) NULL,
		  `url_retour` VARCHAR( 500 ) NOT NULL,
		  `click_out` INT NOT NULL DEFAULT 1,
		  `tempsaffichage` INT NOT NULL DEFAULT 3600000,
		  `color` VARCHAR(10) NULL,
		  `colorpopup` VARCHAR(10) NULL,
		  `imgfond` VARCHAR(50) NULL,
		  `opacity` INT NOT NULL, 
		  `width` INT NULL,
		  `height` INT NULL,
		  `active` INT NOT NULL
		) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;');
		Db::getInstance()->ExecuteS('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'dommessage_page_lang` (
		  `id_page` INT NOT NULL ,
		  `id_lang` TINYINT( 1 ) NOT NULL,
		  `description` BLOB NULL,
		  PRIMARY KEY  (`id_page`,`id_lang`)
		) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;');
		Db::getInstance()->ExecuteS('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'dommessage_page_category` (
		  `id_page` INT  NOT NULL,
		  `id_category` INT NOT NULL,
		  PRIMARY KEY  (`id_page`,`id_category`)
		) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;');	
		return true;
	}
	
	private function majb2d() {
		$test = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `'._DB_PREFIX_.'dommessage_page` LIKE \'url_retour\'');
		if (count($test) == 0) {
			if (Db::getInstance()->Execute('ALTER TABLE  `'._DB_PREFIX_.'dommessage_page` ADD  `url_retour` VARCHAR( 500 ) NOT NULL AFTER  `mode`')) Configuration::updateValue('MOD_DOMPAGECATEGORY_VERSION', '2.0');
		}
		$test = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `'._DB_PREFIX_.'dommessage_page` LIKE \'`click_out`\'');
		if (count($test) == 0) {
			if (Db::getInstance()->Execute('ALTER TABLE  `'._DB_PREFIX_.'dommessage_page` ADD  `click_out` INT NOT NULL DEFAULT 1 AFTER  `url_retour`')) Configuration::updateValue('MOD_DOMPAGECATEGORY_VERSION', '2.1');
		}
	}
	
	public function uninstall()
	{
		if(!parent::uninstall() || 
		   !Configuration::deleteByName('MOD_DOMPAGECATEGORY_ACTIVE') || 
		   !Configuration::deleteByName('MOD_DOMPAGECATEGORY_VERSION') ||
			!$this->uninstallModuleTab('AdminDomMessageCategory') ||
		   !$this->uninstallDb())
		  return false;
		return true;
	}
	
  private function uninstallModuleTab($tabClass) {
    $idTab = Tab::getIdFromClassName($tabClass);
    if($idTab != 0)
    {
      $tab = new Tab($idTab);
      $tab->delete();
      return true;
    }
    return false;
  }

	private function uninstallDb() {
		Db::getInstance()->ExecuteS('DROP TABLE `'._DB_PREFIX_.'dommessage_page`');
		Db::getInstance()->ExecuteS('DROP TABLE `'._DB_PREFIX_.'dommessage_page_lang`');
		Db::getInstance()->ExecuteS('DROP TABLE `'._DB_PREFIX_.'dommessage_page_category`');	
		return true;
	}
		
	function recurseCategory($indexedCategories, $categories, $current, $id_category = 1, $id_category_default = NULL, $CategorySelected)
	{
		global $done;
		static $irow;
		if(!is_array($CategorySelected))
			$CategorySelected = array();
		$id_obj = intval(Tools::getValue($this->identifier));
		if (!isset($done[$current['infos']['id_parent']]))
			$done[$current['infos']['id_parent']] = 0;
		$done[$current['infos']['id_parent']] += 1;

		$todo = sizeof($categories[$current['infos']['id_parent']]);
		$doneC = $done[$current['infos']['id_parent']];

		$level = $current['infos']['level_depth'] + 1;
		if (_PS_VERSION_ > '1.4')
			$img = $level == 1 ? 'lv1.gif' : 'lv'.$level.'_'.($todo == $doneC ? 'f' : 'b').'.png';
		else
			$img = $level == 1 ? 'lv1.gif' : 'lv'.$level.'_'.($todo == $doneC ? 'f' : 'b').'.gif';

		$this->_pageHtml .= '
		<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
			<td>
				<input type="checkbox" name="categoryBox[]" class="categoryBox'.($id_category_default != NULL ? ' id_category_default' : '').'" id="categoryBox_'.$id_category.'" value="'.$id_category.'"'.(((in_array($id_category, $indexedCategories) OR (intval(Tools::getValue('id_category')) == $id_category AND !intval($id_obj))) OR in_array($id_category, $CategorySelected)) ? ' checked="checked"' : '').' />
			</td>
			<td>
				'.$id_category.'
			</td>
			<td>
				<img src="../img/admin/'.$img.'" alt="" /> &nbsp;<label for="categoryBox_'.$id_category.'" class="t">'.stripslashes(Category::hideCategoryPosition($current['infos']['name'])).'</label>
			</td>
		</tr>';

		if (isset($categories[$id_category]))
			foreach ($categories[$id_category] AS $key => $row)
				if ($key != 'infos')
					$this->recurseCategory($indexedCategories, $categories, $categories[$id_category][$key], $key, NULL, $CategorySelected);
	}	
	
	public function getContent()
	{
		global $cookie;
		global $editInProgress;
		global $ErrorAdd;
		$output = "";
		if (Tools::getValue('tempsaffiche') == 0 || Tools::getValue('Permanent') == false) { $valtempaffiche = 3600000; } else { $valtempaffiche = Tools::getValue('tempsaffiche')*1000 ; }
		if (Tools::getValue('avecImage') == true && Tools::getValue('imgfond') != '' && Tools::getValue('imgfond') != NULL) $valImgFond = Tools::getValue('imgfond'); else $valImgFond = NULL;
		if (Tools::getValue('clicOut') == true) $valClickOut = 1; else $valClickOut = 0;

		if (Tools::isSubmit('actionForm'))
		{
			switch(trim(Tools::getValue('actionForm'))) {
				case 'add':
				$languages = Language::getLanguages();
				if(Tools::getValue('categoryBox') == '') { $errors[$p++] = $this->l('category') ; $output .= $this->displayError($this->l('Category is required.')); } else false;
				if(Tools::getValue('name') == '') { $errors[$p++] = $this->l('name') ; $output .= $this->displayError($this->l('Name is required.')); } else false;
				if(Tools::getValue('color') == '') { $errors[$p++] = $this->l('color') ; $output .= $this->displayError($this->l('Color is required.')); } else false;
				if(Tools::getValue('colorpopup') == '') { $errors[$p++] = $this->l('colorpopup') ; $output .= $this->displayError($this->l('Colorpopup is required.')); } else false;
				if(Tools::getValue('opacity') == '') { $errors[$p++] = $this->l('opacity') ; $output .= $this->displayError($this->l('Opacity is required.')); } else false;
				if(Tools::getValue('width') == '') { $errors[$p++] = $this->l('width') ; $output .= $this->displayError($this->l('Width is required.')); } else false;
				if(Tools::getValue('height') == '') { $errors[$p++] = $this->l('height') ; $output .= $this->displayError($this->l('Height is required.')); } else false;
				if(Tools::getValue('activeSpecialPage') == '') { $errors[$p++] = $this->l('activeSpecialPage') ; $output .= $this->displayError($this->l('Status is required.')); } else false;
				if(count($errors)!=0) {
					$output .= $this->displayError($this->l('Unable to add this special page.'));
					$ErrorAdd = 1;
				}
				else {
					Db::getInstance()->autoExecute(
					  _DB_PREFIX_.'dommessage_page',
					  array(
						'name'=>Tools::getValue('name'),
						'display'=>Tools::getValue('DisplayType'),
						'viecookieheure'=>Tools::getValue('vieheure'),
						'viecookieminute'=>Tools::getValue('vieminute'),
						'mode'=>Tools::getValue('mode'),
						'url_retour' => Tools::getValue('url_retour'),
						'click_out' => $valClickOut,
						'tempsaffichage'=>$valtempaffiche,
						'color'=>Tools::getValue('color'),
						'colorpopup'=>Tools::getValue('colorpopup'),
						'imgfond'=>$valImgFond,
						'opacity'=>Tools::getValue('opacity'),
						'width'=>Tools::getValue('width'),
						'height'=>Tools::getValue('height'),
						'active'=>Tools::getValue('activeSpecialPage')
					  ),
					  'INSERT'
					);		
					$id_SpecialPage = Db::getInstance()->Insert_ID();	
					foreach ($languages as $language) {
						Db::getInstance()->autoExecute(
						  _DB_PREFIX_.'dommessage_page_lang',
						  array(
							'id_page'=>$id_SpecialPage,
							'id_lang'=>intval($language['id_lang']),
							'description'=>addslashes(Tools::getValue('body_message_'.$language['id_lang']))
						  ),
						  'INSERT'
						);		
					}	
						
					foreach(Tools::getValue('categoryBox') as $id_cat=>$cat) {
					  Db::getInstance()->autoExecute(
						_DB_PREFIX_.'dommessage_page_category',
						array(
						  'id_page'=>$id_SpecialPage,
						  'id_category'=>$cat
						),
						'INSERT'
					  );
					}	
					$output .= $this->displayConfirmation($this->l('The special page has been added'));
				}				
				break;
				case 'delete':
					Db::getInstance()->delete(_DB_PREFIX_.'dommessage_page', "id_page = ".Tools::getValue('SpecialPageEditDelete')); 
					Db::getInstance()->delete(_DB_PREFIX_.'dommessage_page_lang', "id_page = ".Tools::getValue('SpecialPageEditDelete')); 
					Db::getInstance()->delete(_DB_PREFIX_.'dommessage_page_category', "id_page = ".Tools::getValue('SpecialPageEditDelete')); 				
					$output .= $this->displayConfirmation($this->l('The special page has been deleted'));
				break;
				case 'edit':
					$editInProgress = 1;
					
				break;
				case 'update':
					$languages = Language::getLanguages();
					if(Tools::getValue('categoryBox') == '') { $errors[$p++] = $this->l('category') ; $output .= $this->displayError($this->l('Category is required.')); } else false;
					if(Tools::getValue('name') == '') { $errors[$p++] = $this->l('name') ; $output .= $this->displayError($this->l('Name is required.')); } else false;
					if(Tools::getValue('color') == '') { $errors[$p++] = $this->l('color') ; $output .= $this->displayError($this->l('Color is required.')); } else false;
					if(Tools::getValue('colorpopup') == '') { $errors[$p++] = $this->l('colorpopup') ; $output .= $this->displayError($this->l('Colorpopup is required.')); } else false;
					if(Tools::getValue('opacity') == '') { $errors[$p++] = $this->l('opacity') ; $output .= $this->displayError($this->l('Opacity is required.')); } else false;
					if(Tools::getValue('width') == '') { $errors[$p++] = $this->l('width') ; $output .= $this->displayError($this->l('Width is required.')); } else false;
					if(Tools::getValue('height') == '') { $errors[$p++] = $this->l('height') ; $output .= $this->displayError($this->l('Height is required.')); } else false;
					if(Tools::getValue('activeSpecialPage') == '') { $errors[$p++] = $this->l('activeSpecialPage') ; $output .= $this->displayError($this->l('Category is required.')); } else false;
					if(count($errors)!=0) {
						$output .= $this->displayError($this->l('Unable to update this special page.'));
						$ErrorAdd = 1;
					}
					else {
						Db::getInstance()->Execute('
						UPDATE '._DB_PREFIX_.'dommessage_page SET 
							name="'.Tools::getValue('name').'", 
							display="'.Tools::getValue('DisplayType').'",
							viecookieheure="'.Tools::getValue('vieheure').'",
							viecookieminute="'.Tools::getValue('vieminute').'",
							mode="'.Tools::getValue('mode').'",
							url_retour="'.Tools::getValue('url_retour').'",
							click_out ="'.$valClickOut.'",
							tempsaffichage='.$valtempaffiche.',
							color="'.Tools::getValue('color').'",
							colorpopup="'.Tools::getValue('colorpopup').'",
							imgfond="'.$valImgFond.'",
							opacity="'.Tools::getValue('opacity').'", 
							width="'.Tools::getValue('width').'",
							height="'.Tools::getValue('height').'", 
							active="'.Tools::getValue('activeSpecialPage').'" WHERE id_page='.Tools::getValue('idSpecialPageToUpdate').'
						');
						
						Db::getInstance()->delete(_DB_PREFIX_.'dommessage_page_lang', "id_page = ".Tools::getValue('idSpecialPageToUpdate')); 
						foreach ($languages as $language) {
						  Db::getInstance()->autoExecute(
							_DB_PREFIX_.'dommessage_page_lang',
							array(
							  'id_page'=>Tools::getValue('idSpecialPageToUpdate'),
							  'id_lang'=>intval($language['id_lang']),
							  'description'=>Tools::getValue('body_message_'.$language['id_lang'])
							),
							'INSERT'
						  );
						}
						
						Db::getInstance()->delete(_DB_PREFIX_.'dommessage_page_category', "id_page = ".Tools::getValue('idSpecialPageToUpdate'));
					
						foreach(Tools::getValue('categoryBox') as $id_cat=>$cat) {
						  Db::getInstance()->autoExecute(
							_DB_PREFIX_.'dommessage_page_category',
							array(
							  'id_page'=>Tools::getValue('idSpecialPageToUpdate'),
							  'id_category'=>$cat
							),
							'INSERT'
						  );
						}		
						$output .= $this->displayConfirmation($this->l('The special page has been updated.'));
					}
				break;
				
				case 'DeleteImage':
					$fichier = dirname(__FILE__).'/background/'.Tools::getValue('NameFileDelete');
					if(file_exists($fichier)) {
						if (unlink($fichier)) $output .= $this->displayConfirmation($this->l('File').' "'.Tools::getValue('NameFileDelete').'" '.$this->l('deleted')); else $output .= $this->displayError($this->l('error when deleting').' "'.Tools::getValue('NameFileDelete').'"');
					} else $output .= $this->displayError($this->l('Image').' "'.Tools::getValue('NameFileDelete').'" '.$this->l('no found'));
				break;
				
				case 'AddImage':
					if ( isset($_FILES['NewImage']['name']) ) {
							$img = dirname(__FILE__).'/background/'.$_FILES['NewImage']['name'];
							if ( !move_uploaded_file( $_FILES['NewImage']['tmp_name'], $img ) ){
								$output .= $this->displayError($this->l('Error while upload picture').' "'.$_FILES['NewImage']['name'].'"');
							} else { $output .= $this->displayConfirmation($this->l('Picture').' "'.$_FILES['NewImage']['name'].'" '.$this->l('uploaded')); }
						}
				break;
			}
		}
		return $output.$this->displayForm();
	}

	static public function getSpecialList() {
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM '._DB_PREFIX_.'dommessage_page' );
	}	

	static public function getSpecialListEdit($id_SpecialPage) {
		return Db::getInstance()->ExecuteS('
		SELECT *  
		FROM '._DB_PREFIX_.'dommessage_page WHERE `id_page`='.$id_SpecialPage );
	}
	static public function getSpecialListEditLang($id_SpecialPage) {
		return Db::getInstance()->ExecuteS('
		SELECT id_lang, description 
		FROM '._DB_PREFIX_.'dommessage_page_lang WHERE `id_page`='.$id_SpecialPage );
	}	
	static public function getSpecialListEditCategory($id_SpecialPage) {
		return Db::getInstance()->ExecuteS('
		SELECT id_category 
		FROM '._DB_PREFIX_.'dommessage_page_category WHERE `id_page`='.$id_SpecialPage );
	}
	static public function getCategoryProduct($idProduct) {
		return Db::getInstance()->ExecuteS('
		SELECT id_category     
		FROM '._DB_PREFIX_.'category_product WHERE id_product='.$idProduct);
	}

	static public function getSpecialListTpl($id_lang, $idCategoryPage) {
		return Db::getInstance()->ExecuteS('
		SELECT tb.id_page, tb.color, tb.colorpopup, tb.imgfond, tb.width, tb.height, tb.opacity, tb.viecookieheure, tb.viecookieminute, tb.tempsaffichage, tbll.description, tb.display, tb.mode , tb.url_retour , tb.click_out   
		FROM ('._DB_PREFIX_.'dommessage_page tb INNER JOIN '._DB_PREFIX_.'dommessage_page_category tbl ON
		(tb.id_page=tbl.id_page)) INNER JOIN '._DB_PREFIX_.'dommessage_page_lang tbll ON 
		(tb.id_page=tbll.id_page) WHERE tb.active=1 AND tbl.id_category='.$idCategoryPage.' AND tbll.id_lang='.$id_lang );
	}
				
	private function displayForm()
	{
		global $cookie;
		global $editInProgress;
		global $ErrorAdd;
		global $irow;
		$tab_category = array();
		$tab_descriptions = array();
		$tabCategorySelected = array();
		if($editInProgress==1) {
			$SpecialListEdit 			= $this->getSpecialListEdit(Tools::getValue('SpecialPageEditDelete'));
			$SpecialListEditLang 		= $this->getSpecialListEditLang(Tools::getValue('SpecialPageEditDelete'));
			$SpecialListEditCategory 	= $this->getSpecialListEditCategory(Tools::getValue('SpecialPageEditDelete'));
			if(count($SpecialListEditLang)!=0)
				foreach($SpecialListEditLang as $k)
						$tab_descriptions[$k['id_lang']] = $k['description'];
			if(count($SpecialListEditCategory)!=0)
				foreach($SpecialListEditCategory as $k)
						$tabCategorySelected[$k['id_category']] = $k['id_category'];
		}
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		//$iso = Language::getIsoById($defaultLanguage);	
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$this->_pageHtml = '
		<link rel="stylesheet" href="'.$this->_path.'css/infobulle.css" type="text/css" />
		<link rel="stylesheet" href="'.$this->_path.'css/colorpicker.css" type="text/css" />
		<link rel="stylesheet" href="'.$this->_path.'css/layout.css" type="text/css"/>
		<link rel="stylesheet" href="'.$this->_path.'css/thickbox.css" type="text/css"/>
		<script type="text/javascript" src="'.$this->_path.'js/colorpicker.js"></script>
		<script type="text/javascript" src="'.$this->_path.'js/eye.js"></script>
		<script type="text/javascript" src="'.$this->_path.'js/layout.js?ver=1.0.2"></script>		
		<script type="text/javascript" src="'.$this->_path.'js/utils.js"></script>	
		<script type="text/javascript" src="'.$this->_path.'js/domscript.js"></script>	
		<script type="text/javascript" src="'.$this->_path.'js/thickbox.js"></script>';
		$this->_pageHtml .= $this->chercheMaj();
		$this->displayDon();
		// TinyMCE
		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_pageHtml .= '
		<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
			</script>
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		// Fin TinyMCE
		$this->_pageHtml .='
			<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>		
			<form action="'.$_SERVER['REQUEST_URI'].'" method="post" name="SpecialPageForm">';
		$this->_pageHtml .='<br />&nbsp;<br /><fieldset>
			<legend><img src="'.$this->_path.'logo.gif">'.$this->l('Special pages list for categories').'</legend>
				<table cellpadding="0" class="table" width="100%">
					<tr>
						<Th width="20">'.$this->l('ID').'</Th>
						<th>'.$this->l('name').'</th>
						<th width="20">'.$this->l('Status').'</th>
						<th width="40" colspan="2">'.$this->l('Actions').'</th>
					</tr>
					';
			$lng = 0;
			$SpecialPageList = $this->getSpecialList();
			if(count($SpecialPageList)!=0)
				foreach ($SpecialPageList as $SpecialPage) {	
					$this->_pageHtml .= '<tr class="'.($lng++ % 2 ? 'alt_row' : '').'"><td width="20">'.$SpecialPage['id_page'].'</td><td>'.$SpecialPage['name'].'</td><td align="center">'.(($SpecialPage['active']==1) ? '<img src="../img/admin/enabled.gif">' : '<img src="../img/admin/disabled.gif">').'</td><td width="20"><img src="../img/admin/edit.gif" title="'.$this->l('Edit').'" onClick="editSpecialPage(\''.$SpecialPage['id_page'].'\')" style="cursor:pointer"></td><td width="20"><img src="../img/admin/disabled.gif" title="'.$this->l('Delete').'" onClick="deleteSpecialPage(\''.$SpecialPage['id_page'].'\')" style="cursor:pointer"></td></tr>';
					}
		$this->_pageHtml .='</table>';
		$this->_pageHtml .='<input type="hidden" id="SpecialPageEditDelete" name="SpecialPageEditDelete" value="">';
		$this->_pageHtml .='</fieldset><br />';
		$this->_pageHtml .= '<fieldset><legend><img src="'.$this->_path.'images/parametres.gif" alt="" title="" />'.$this->l('Settings').'</legend>';
		$infobulle = '$this->_pageHtml .= \'<a class="info" href="#" onclick="return false;"><img src="../img/admin/help.png" /><span>\'.$message.\'</span></a>\';';
		$this->_pageHtml .='<label>'.$this->l('Name').': </label>';
		$this->_pageHtml .='<div class="margin-form">
							<input type ="text" id="name" name="name" value="'.(($editInProgress==1) ? $SpecialListEdit[0]['name'] : (($ErrorAdd==1) ? Tools::getValue('name') : "")).'"><sup> *</sup>&nbsp;&nbsp;';
		$message = 'Le nom ne sera pas visible dans le Front Office, mais il est obligatoire afin de classer plus facilement vos messages dans le Back Office.';
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<label>'.$this->l('Categories').': </label>
					<div class="margin-form">
							<table cellspacing="0" cellpadding="0" class="table" width="100%">
									<tr>
										<th width="20"><input type="checkbox" name="checkme" class="noborder" onclick="checkDelBoxes(this.form, \'categoryBox[]\', this.checked)" /></th>
										<th width="20">'.$this->l('ID').'</th>
										<th>'.$this->l('Name').'</th>
									</tr>
									<tr class="">
										<td width="20"><input type="checkbox" name="categoryBox[]" class="categoryBox" value="0" '.(in_array("0", $tabCategorySelected) ? " checked" : "").'/></td>
										<td width="20">0</td>
										<td>&nbsp;<label for="categoryBox_'.$id_category.'" class="t">'.$this->l('Home page').'</label></td>
									</tr>';
		$irow = 0;
		$done = array();
		$index = array();
		$indexedCategories = array();
		$categories = Category::getCategories(intval($cookie->id_lang), false);
		foreach ($indexedCategories AS $k => $row)
			$index[] = $row['id_category'];									
		$this->recurseCategory($index, $categories, $categories[0][1], 1, $obj->id, $tabCategorySelected);
		$this->_pageHtml .='</table><br />';
		$message = 'Ci-dessus : Sélectionnez la ou les catégories dans lesquelles le message Popup sera affiché.<br />Ci-dessous : Entrez le texte que contientiendra votre Popup.';
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<label>'.$this->l('Message').'</label>
				<div class="margin-form">';
		foreach ($languages as $language) {
			$existing_message = ($ErrorAdd==1) ? Tools::getValue('body_message_'.$language['id_lang']) : $tab_descriptions[$language['id_lang']];
			$this->_pageHtml .= '
					<div id="InformMessage_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
						<textarea class="rte" cols="70" rows="30" id="body_message_'.$language['id_lang'].'" name="body_message_'.$language['id_lang'].'">' . $existing_message . '</textarea>
					</div>';
		}
		$this->_pageHtml .= $this->displayFlags($languages, $defaultLanguage, 'InformMessage', 'InformMessage', true);				
		$this->_pageHtml .='</div><div class="clear pspace"></div>';	
		$this->_pageHtml .='<label>'.$this->l('Mode').': </label>';
		$this->_pageHtml .='<div class="margin-form">
				<select id="mode" name="mode" style="width: 100px;" onchange="retoururl();">';
		$this->_pageHtml .= '<option value="close" '.(($editInProgress==1) ? (($SpecialListEdit[0]['mode']=='close') ? " selected" : "") : ((Tools::getValue('display')=='close') ? (($ErrorAdd==1) ? " selected" : "") : "")).'>'.$this->l('Close').'</option>';
		$this->_pageHtml .= '<option value="confirm" '.(($editInProgress==1) ? (($SpecialListEdit[0]['mode']=='confirm') ? " selected" : "") : ((Tools::getValue('display')=='confirm') ? (($ErrorAdd==1) ? " selected" : "") : "")).'>'.$this->l('Confirmation').'</option>';
		$this->_pageHtml .='</select>';
		$this->_pageHtml .='<span id="span_url_retour"> &nbsp; &nbsp; 
			<input type ="text" id="url_retour" name="url_retour" size=60 value="'.(($editInProgress==1) ? $SpecialListEdit[0]['url_retour'] : (($ErrorAdd==1) ? Tools::getValue('url_retour') : "")).'" />
			</span>&nbsp;&nbsp;';
		$message = "Le mode \"Fermeture\" affiche un unique bouton OK.<br />Le mode \"Confirmation\" valide l'accès via OK, renvoi sur une autre page si Annuler.<br />En mode \"Confirmation\", entrez l'adresse URL de renvoi si l'internaute clique sur \"Annnuler\". Commencez par HTTP://<br />Si vous laissez ce champs vide, l'internaute sera redirigé vers la page à laquelle il vient.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<script type="text/javascript">retoururl();</script>';
		$this->_pageHtml .='<label>'.$this->l('Display').': </label>';
		$this->_pageHtml .='<div class="margin-form">';
		$this->_pageHtml .='<select id="DisplayType" name="DisplayType" style="width: 100px;" onchange="time_cookie();">';
		$this->_pageHtml .= '<option value="always" '.(($editInProgress==1) ? (($SpecialListEdit[0]['display']=='always') ? " selected" : "") : ((Tools::getValue('display')=='always') ? (($ErrorAdd==1) ? " selected" : "") : "")).'>'.$this->l('Always').'</option>';
		$this->_pageHtml .= '<option value="once" '.(($editInProgress==1) ? (($SpecialListEdit[0]['display']=='once') ? " selected" : "") : ((Tools::getValue('display')=='once') ? (($ErrorAdd==1) ? " selected" : "") : "")).'>'.$this->l('One time').'</option>';
		$this->_pageHtml .='</select>';
		$this->_pageHtml .='<span id="span_time_cookie"> &nbsp; &nbsp; '.$this->l('If display').' "'.$this->l('One time').'", '.$this->l('time to redraw:').' ';
		$this->_pageHtml .='<input type ="text" id="vieheure" name="vieheure" size=3 value="'.(($editInProgress==1) ? $SpecialListEdit[0]['viecookieheure'] : 		 (($ErrorAdd==1) ? Tools::getValue('viecookieheure') : 24)).'" onkeypress="chiffres(event)">&nbsp; H &nbsp;';
		$this->_pageHtml .='<input type ="text" id="vieminute" name="vieminute" size=2 value="'.(($editInProgress==1) ? $SpecialListEdit[0]['viecookieminute'] : (($ErrorAdd==1) ? Tools::getValue('viecookieminute') : 0)).'" onkeypress="chiffres(event)">&nbsp; Mins </span>&nbsp;&nbsp;';
		$message = "Le mode \"Toujours\" Permet d'afficher le popup à chaque consultation de la page.<br />Le mode \"Une fois\", permet d'afficher le popup qu'une seule fois à un même visiteur. Le délai avant réaffichage est réglé en Heures et minutes lorsque l'on choisi \"Une fois\".";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<script type="text/javascript">time_cookie();</script>';
		$this->_pageHtml .='<label>'.$this->l('Automatic closure').': </label>';
		$this->_pageHtml .='<div class="margin-form">';
		$this->_pageHtml .='<input type="checkbox" id="Permanent" name="Permanent" ';
		if ($SpecialListEdit[0]['tempsaffichage'] != 3600000 && $SpecialListEdit[0]['tempsaffichage'] != 0) { $this->_pageHtml .= 'checked '; }
		$this->_pageHtml .='onClick="time_affiche();">';
		$this->_pageHtml .='<span id="span_time_affiche"> &nbsp; &nbsp; '.$this->l('Close after:').' &nbsp;&nbsp;';
//		$this->_pageHtml .='<input type ="text" id="tempsaffiche" name="tempsaffiche" size=5 value="'.(($editInProgress==1) ? $SpecialListEdit[0]['tempsaffichage']/1000 : (($ErrorAdd==1) ? Tools::getValue('tempsaffichage') : 0)).'" onkeypress="chiffres(event)">&nbsp; Secondes </span>';
		$this->_pageHtml .='<input type ="text" id="tempsaffiche" name="tempsaffiche" size=5 value="'.(($editInProgress==1) ? (($SpecialListEdit[0]['tempsaffichage'] != 3600000) ? $SpecialListEdit[0]['tempsaffichage']/1000 : 0  )   : (($ErrorAdd==1) ? Tools::getValue('tempsaffichage') : 0)).'" onkeypress="chiffres(event)">&nbsp; '.$this->l('Second').' ('.$this->l('Invalid message to confirm whether').') </span>&nbsp;&nbsp;';
		$message = "Cette option permet lorsque l'on est en mode \"Fermeture\", de fermer automatiquement la popup après x secondes d'affichage.<br/>Si vous êtes en mode \"Confirmation\", ce réglage est ignoré.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<script type="text/javascript">time_affiche();</script><br />';
		$this->_pageHtml .='<label>'.$this->l('click out popup').': </label>';
		$this->_pageHtml .='<div class="margin-form">';
		$this->_pageHtml .='<input type="checkbox" id="clicOut" name="clicOut"';
		if ($SpecialListEdit[0]['click_out'] == 1) $this->_pageHtml .= ' checked="checked"';
		$this->_pageHtml .='">&nbsp;&nbsp;';
		$message = "Cette option permet d'autoriser la fermeture de la boite de dialogue lorsque l'utilisateur clique en dehors de celle-ci.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div><br />';
		$this->_pageHtml .='<label>'.$this->l('background image Popup').': </label>';
		$this->_pageHtml .='<div class="margin-form"><input type="checkbox" id="avecImage" name="avecImage" ';
					if ($SpecialListEdit[0]['imgfond'] != "" && $SpecialListEdit[0]['imgfond'] != NULL) { $this->_pageHtml .= 'checked="checked" '; }
		$this->_pageHtml .='onClick="imgfond_affiche();">';
		$this->_pageHtml .='&nbsp;&nbsp;&nbsp;'.$this->l('Display a background image popup').'&nbsp;&nbsp;&nbsp;';
		$this->_pageHtml .='<span id="span_img_fond"><select id="imgfond" name="imgfond" style="width: 200px;">';
					$liste_rep = scandir(_PS_MODULE_DIR_.'dommessagecategory/background');
					$i = 0;
					$num = count($liste_rep);
					while($i < $num){
						$size = getimagesize(_PS_MODULE_DIR_.'dommessagecategory/background/'.$liste_rep[$i]);
						if($size) {
							$this->_pageHtml .= '<option value="'.$liste_rep[$i].'" ';
							if($liste_rep[$i]==$SpecialListEdit[0]['imgfond']) $this->_pageHtml .= 'selected>'; else $this->_pageHtml .= '>';
							$this->_pageHtml .= $liste_rep[$i].'</option>';
						}
						$i++;
					}
		$this->_pageHtml .='</select></span>&nbsp;&nbsp;';
		$message = "Permet de choisir une image de fond de popup plutôt qu'un fond de couleur uni.<br />Les images sont modifiables à l'aide du gestionnaire d'image en bas de cette page.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';
		$this->_pageHtml .='<script type="text/javascript">imgfond_affiche();</script><br />';
		
		$this->_pageHtml .='<label>'.$this->l('background color Popup').': </label><div class="margin-form">
					<div id="customWidget3">
						<input type="hidden" name="colorpopup" value="'.(($editInProgress==1) ? $SpecialListEdit[0]['colorpopup'] : (($ErrorAdd==1) ? Tools::getValue('colorpopup') : "000000")).'" id="HiddenColor3">		
						<div id="colorSelector3"><div style="background-color: #'.(($editInProgress==1) ? $SpecialListEdit[0]['colorpopup'] : (($ErrorAdd==1) ? Tools::getValue('colorpopup') : "000000")).'"></div></div>
						<div id="colorpickerHolder3" style="z-index : 1001"></div>
					</div>'.$this->l('Background color of the popup.').'&nbsp;&nbsp;';
		$message = "Vous pouvez choisir la couleur de fond du popup.<br/>Cliquez sur le carré de couleur pour ouvrir le sélecteur de couleur.<br />Une fois votre choix effectué, cliquez sur le dessin multicolore en bas à droite du sélecteur de couleur pour valider votre choix.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';			
		$this->_pageHtml .='<label>'.$this->l('Background color Mask').': </label><div class="margin-form">
					<div id="customWidget">
						<input type="hidden" name="color" value="'.(($editInProgress==1) ? $SpecialListEdit[0]['color'] : (($ErrorAdd==1) ? Tools::getValue('color') : "000000")).'" id="HiddenColor2">		
						<div id="colorSelector2"><div style="background-color: #'.(($editInProgress==1) ? $SpecialListEdit[0]['color'] : (($ErrorAdd==1) ? Tools::getValue('color') : "000000")).'"></div></div>
						<div id="colorpickerHolder2" style="z-index : 1001"></div>
					</div>'.$this->l('Background color of the mask.').'&nbsp;&nbsp;';
		$message = "Vous pouvez choisir la couleur de fond autour du popup.<br />Cette couleur est un masque va remplir votre page autour du popup afin de le faire ressortir.<br/>Vous avez dans le réglage suivant la possibilité de régler le pourcentage d'opacité (de transparence) de ce masque.<br />Cliquez sur le carré de couleur pour ouvrir le sélecteur de couleur.<br />Une fois votre choix effectué, cliquez sur le dessin multicolore en bas à droite du sélecteur de couleur pour valider votre choix.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';				
		$this->_pageHtml .='<label>'.$this->l('Opacity').': </label>';
		$this->_pageHtml .='<div class="margin-form">
							<select id="opacity" name="opacity" style="width: 60px;">';
							for($o=10; $o<=100; $o=$o+10)
								$this->_pageHtml .= '<option value="'.$o.'" '.(($editInProgress==1) ? (($SpecialListEdit[0]['opacity']==$o) ? " selected" : "") : ((Tools::getValue('opacity')==$o) ? (($ErrorAdd==1) ? " selected" : "") : "")).'>'.$o.'%</option>';
		$this->_pageHtml .='</select>
							<br />'.$this->l('Opacity mask.').'&nbsp;&nbsp;';
		$message = "Réglage de l'opacité (de la transparence) de la couleur du masque autour de la popup.<br/>Plus le pourcentage est faible, plus la transparence est accentuée.<br />Plus le pourcentage est élevé, plus la couleur est renforcée.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>';		
		$this->_pageHtml .='<label>'.$this->l('Width').': </label>';
		$this->_pageHtml .='<div class="margin-form">
							<input type ="text" id="width" name="width" value="'.(($editInProgress==1) ? $SpecialListEdit[0]['width'] : (($ErrorAdd==1) ? Tools::getValue('width') : false)).'" onkeypress="chiffres(event)">&nbsp;px<sup> *</sup>&nbsp;&nbsp;';
		$message = "Réglage de la Largeur du Popup.<br/>Cette valeur doit obligatoirement être renseignée.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='<p>'.$this->l('Frame width in special page.').'</p></div>';
		$this->_pageHtml .='<label>'.$this->l('Height').': </label>';
		$this->_pageHtml .='<div class="margin-form">
							<input type ="text" id="height" name="height" value="'.(($editInProgress==1) ? $SpecialListEdit[0]['height'] : (($ErrorAdd==1) ? Tools::getValue('height') : false)).'" onkeypress="chiffres(event)">&nbsp;px<sup> *</sup>&nbsp;&nbsp;';
		$message = "Réglage de la Hauteur du Popup.<br/>Cette valeur doit obligatoirement être renseignée.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='<p>'.$this->l('Frame height in special page.').'</p></div>';
		$this->_pageHtml .='<label>'.$this->l('Status').': </label>
				<div class="margin-form">
					<input type="radio" name="activeSpecialPage" value="1" '.(($editInProgress==1) ? (($SpecialListEdit[0]['active']==1) ? " checked" : "") : " checked").'/>
					<label class="t" for="active_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="activeSpecialPage" value="0" '.(($editInProgress==1) ? (($SpecialListEdit[0]['active']==0) ? " checked" : "") : ((Tools::getValue('activeSpecialPage')=='0') ? (($ErrorAdd==1) ? " checked" : "") : "")).'/>
					<label class="t" for="active_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<br />'.$this->l('Enable or disable special page').'&nbsp;&nbsp;';
		$message = "Permet d'activer ou de désactiver un message Popup sans qu'il soit effacé.";
		$this->_pageHtml .= eval($infobulle);
		$this->_pageHtml .='</div>
				<input type="hidden" id="actionForm" name="actionForm" value="add">
				<div class="margin-form">';
					if($editInProgress==1) {
					$this->_pageHtml .= '<input type="button" value="'.$this->l('   Update   ').'" name="submitSpecialPage" class="button" onClick="updateSpecialPage(\''.$SpecialListEdit[0]['id_page'].'\')" />
					<input type="hidden" id="idSpecialPageToUpdate" name="idSpecialPageToUpdate" value="'.$SpecialListEdit[0]['id_page'].'">';
					}
					else
					$this->_pageHtml .= '<input type="submit" value="'.$this->l('   Save   ').'" name="submitSpecialPage" class="button" />';
				$this->_pageHtml .= '</div>
			</fieldset>
			';
		
		// Gestion images
		$this->_pageHtml .= '<br /><fieldset>
				<legend><img src="'.$this->_path.'images/fileAdd.gif" alt="" title="" />'.$this->l('Picture mode').'</legend>';
		$this->_pageHtml .= '<label>'.$this->l('Images on the site:').' </label>';
		$this->_pageHtml .= '<div class="margin-form"><table cellpadding="0" class="table" width="100%">
					<tr>
						<th>'.$this->l('name image').'</th>
						<th width="100"><center>'.$this->l('Weight').'</center></th>
						<th width="60"><center>'.$this->l('Width').'</center></th>
						<th width="60"><center>'.$this->l('Height').'</center></th>
						<th width="40" colspan="2"><center>'.$this->l('Actions').'</center></th>
					</tr>
					';
		$liste_rep = scandir(_PS_MODULE_DIR_.'dommessagecategory/background');
		$i = 0; $num = count($liste_rep);
		while($i < $num){
			$size = getimagesize(_PS_MODULE_DIR_.'dommessagecategory/background/'.$liste_rep[$i]);
			if($size) {
				$poidImg = filesize(_PS_MODULE_DIR_.'dommessagecategory/background/'.$liste_rep[$i]);
				if ($poidImg < 1024) $poidImg = $poidImg.' B';
   			elseif ($poidImg < 1048576) $poidImg = round($poidImg / 1024, 2).' KB';
   			elseif ($poidImg < 1073741824) $poidImg = round($poidImg / 1048576, 2).' MB';
				$this->_pageHtml .= '<tr class="'.($lng++ % 2 ? 'alt_row' : '').'"><td>'.$liste_rep[$i].'</td>
						<td width="100" align="center">'.$poidImg.'</td>
						<td width="60" align="center">'.$size[0].'</td>
						<td width="60" align="center">'.$size[1].'</td>
						<td width="20"><a href="'.$this->_path.'background/'.$liste_rep[$i].'" class="thickbox"><img src="../img/admin/edit.gif" title="'.$this->l('Edit').'"></a></td>
						<td width="20"><img src="../img/admin/disabled.gif" title="'.$this->l('Delete').'" onClick="deleteImage(\''.$liste_rep[$i].'\')" style="cursor:pointer"></td></tr>
						';
			}
			$i++;
		}
		$this->_pageHtml .='</table>';
		$this->_pageHtml .='<input type="hidden" id="NameFileDelete" name="NameFileDelete" value="">';
		$this->_pageHtml .= '</form><br /></div>';
		$this->_pageHtml .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data" style="display:inline">';
		$this->_pageHtml .='<label>'.$this->l('Add image:').' </label>';
		$this->_pageHtml .='<div class="margin-form"><input type="file" id="NewImage" name="NewImage" style="font-size:10px" size="70"/>&nbsp;&nbsp;
				<input type="hidden" name="actionForm" value="AddImage">
				<input type="submit" class="button" value="'.$this->l('Send').'" name="submitUpdate"/>
				</form></div>';
		$this->_pageHtml .= '</fieldset><br />';
		$this->displayMerci();

		return $this->_pageHtml;
	}
	
	private function chercheMaj() {
		$fichier_xml = 'http://www.aideaunet.com/dommaj/dominfo.xml';
		$domMessage = '';
		// On test l'existance du fichier xml.
		if (@fclose(@fopen($fichier_xml, 'r'))) {
			$raw = file_get_contents($fichier_xml); // Lit le fichier et le place dans la variable $raw
			if ($raw) {
				// On lit la zone de "dominfo".
				if(preg_match('#<aideaunet>(.*)</aideaunet>#is',$raw,$rawdominfo)){
					if(preg_match('#<dommessagecategory>(.*)</dommessagecategory>#is',$rawdominfo[1],$rawinfo)){
						preg_match('#<version>(.*)</version>#is',$rawinfo[1], $versioninfo); 
						preg_match('#<url>(.*)</url>#is',$rawinfo[1], $url);
					}
					if ($this->version < $versioninfo[1]) {
						// Version inférieure, on informe l'utilisateur.
						$domMessage .= '<p>&nbsp;</p><fieldset><legend><img src="../img/admin/module_warning.png" />'.$this->l('Update Available').'</legend>';
						$domMessage .= '<p>'.$this->l('Update module domMessageCategory Available:').'</p><p>';
						$domMessage .= '<p>&nbsp;&nbsp;&nbsp; - '.$this->l('Your version:').' '.$this->version;
						$domMessage .= '<br />&nbsp;&nbsp;&nbsp; - '.$this->l('Version available:').' '.$versioninfo[1].'<br />&nbsp;</p>';
						$domMessage .= $this->l('To perform the update, download the latest version on the following link:').' <a href="'.$url[1].'">http://www.aideaunet.com</a></p>'; 
						// On ajoute les autres informations disponibles.
						if(preg_match("#<nbreinfo>(.*)</nbreinfo>#is",$rawinfo[1], $nbreinfo)){
							if(intval($nbreinfo[1]) > 0) {
								//preg_match("#<infos>(.*)</infos>#is",$rawinfo[1], $infos); 
								$texte = explode("<infos>", $rawinfo[0]); 
								for ($i=1;$i<$nbreinfo[1]+1;$i++) {
									preg_match("#<info_util>(.*)</info_util>#is",$texte[$i], $rawinfoutil);
									$domMessage .= "<blockquote>".$rawinfoutil[1]."</blockquote>";
								} 
							}
						}
						$domMessage .= '</fieldset>';
						$this->warning .= 'Test';
					}
				}
			}
		}
		return $domMessage;
	}
	
	public function displayMerci()
	{
		$this->_pageHtml .= '<p>&nbsp;</p>
		<fieldset>
			<legend><img src="../img/admin/unknown.gif" />'.$this->l('Remerciements').'</legend>';
		$this->_pageHtml .= '<p>Je tiens à remercier BVince, acteur des forums Prestashop, l\'un de ses modules ayant servi de base pour réaliser ce qu\'est devenu aujourd\'hui domMessageCategory.</p>';
		$this->_pageHtml .= '</fieldset>';
	}
	
	public function displayDon()
	{
		$this->_pageHtml .= '<p>&nbsp;</p>
		<fieldset>
			<legend><img src="../img/admin/unknown.gif" alt="'.$this->l('Encourage the development of this module').'" title="" />'.$this->l('Encourage the development of this module').'</legend>';
		$this->_pageHtml .= '<p>'.$this->l('For this module continues to evolve and remain free, please make a donation to its author:').'</p>';
		$this->_pageHtml .= '<p>&nbsp;</p>';
		$this->_pageHtml .= '<div style="margin:0 auto; text-align:center;"><form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
							<input type="hidden" name="cmd" value="_s-xclick">
							<input type="hidden" name="hosted_button_id" value="NQN8DMMHN2Z92">
							<input type="image" src="https://www.paypalobjects.com/fr_FR/FR/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - la solution de paiement en ligne la plus simple et la plus sécurisée !">
							<img alt="" border="0" src="https://www.paypalobjects.com/fr_FR/i/scr/pixel.gif" width="1" height="1">
							</form></div>';
		$this->_pageHtml .= '</fieldset>';
	}
	
	public function hookHeader() {
		Tools::addCSS(($this->_path).'css/dommessagecategory.css', 'all');
	}
	
	function hookTop($params) {
		global $cookie;
		global $smarty;
		if(Configuration::get('MOD_DOMPAGECATEGORY_ACTIVE')=='on') {
			if (basename($_SERVER['PHP_SELF'])=="index.php") {	
				$SpecialPageCategoryBlock = $this->getSpecialListTpl($cookie->id_lang, 0);
				if(count($SpecialPageCategoryBlock)>0) {
					$IdPageTpl = ($SpecialPageCategoryBlock[0]['display']!='always') ? $SpecialPageCategoryBlock[0]['id_page'] : -1;
					if($SpecialPageCategoryBlock[0]['mode']=='confirm') $SpecialPageCategoryBlock[0]['tempsaffichage'] = 3600000 ;
					$smarty->assign(array(
						'colorBackground' => $SpecialPageCategoryBlock[0]['color'],
						'colorPopup' => $SpecialPageCategoryBlock[0]['colorpopup'],
						'widthBox' => $SpecialPageCategoryBlock[0]['width'],
						'heightBox' => $SpecialPageCategoryBlock[0]['height'],
						'positionLeftBox' => (($SpecialPageCategoryBlock[0]['width']/2) * -1),
						'positionTopBox' => (($SpecialPageCategoryBlock[0]['height']/2)*-1),
						'positionLeftClose' => ($SpecialPageCategoryBlock[0]['width']/2)-16,
						'heightTextBox' => $SpecialPageCategoryBlock[0]['height']-25,
						'opaciteBackground' => $SpecialPageCategoryBlock[0]['opacity'],
						'descriptionBox' => $SpecialPageCategoryBlock[0]['description'], 
						'dureeCookieHeure' => $SpecialPageCategoryBlock[0]['viecookieheure'],
						'dureeCookieMin' => $SpecialPageCategoryBlock[0]['viecookieminute'],
						'imgfond' => $SpecialPageCategoryBlock[0]['imgfond'],
						'mode' => $SpecialPageCategoryBlock[0]['mode'],
						'url_retour' => $SpecialPageCategoryBlock[0]['url_retour'],
						'click_out' => $SpecialPageCategoryBlock[0]['click_out'],
						'tempsaffichage' => $SpecialPageCategoryBlock[0]['tempsaffichage'],
						'jsIdPage' => $IdPageTpl
					));
					return $this->display(__FILE__, 'dommessagecategory.tpl');
				}
			}
			else {
				if (isset($_GET['id_category']) AND Validate::isUnsignedId($_GET['id_category'])) {	
					$SpecialPageCategoryBlock = $this->getSpecialListTpl($cookie->id_lang, $_GET['id_category']);
					if(count($SpecialPageCategoryBlock)>0) {
						$IdPageTpl = ($SpecialPageCategoryBlock[0]['display']!='always') ? $SpecialPageCategoryBlock[0]['id_page'] : -1;
						if($SpecialPageCategoryBlock[0]['mode']=='confirm') $SpecialPageCategoryBlock[0]['tempsaffichage'] = 3600000 ;
						$smarty->assign(array(
							'colorBackground' => $SpecialPageCategoryBlock[0]['color'],
							'colorPopup' => $SpecialPageCategoryBlock[0]['colorpopup'],
							'widthBox' => $SpecialPageCategoryBlock[0]['width'],
							'heightBox' => $SpecialPageCategoryBlock[0]['height'],
							'positionLeftBox' => (($SpecialPageCategoryBlock[0]['width']/2) * -1),
							'positionTopBox' => (($SpecialPageCategoryBlock[0]['height']/2)*-1),
							'positionLeftClose' => ($SpecialPageCategoryBlock[0]['width']/2)-16,
							'heightTextBox' => $SpecialPageCategoryBlock[0]['height']-25,
							'opaciteBackground' => $SpecialPageCategoryBlock[0]['opacity'],
							'descriptionBox' => $SpecialPageCategoryBlock[0]['description'], 
							'dureeCookieHeure' => $SpecialPageCategoryBlock[0]['viecookieheure'],
							'dureeCookieMin' => $SpecialPageCategoryBlock[0]['viecookieminute'],
							'imgfond' => $SpecialPageCategoryBlock[0]['imgfond'],
							'mode' => $SpecialPageCategoryBlock[0]['mode'],
							'url_retour' => $SpecialPageCategoryBlock[0]['url_retour'],
							'click_out' => $SpecialPageCategoryBlock[0]['click_out'],
							'tempsaffichage' => $SpecialPageCategoryBlock[0]['tempsaffichage'],
							'jsIdPage' => $IdPageTpl
						));
						return $this->display(__FILE__, 'dommessagecategory.tpl');
					}
				}
				if (isset($_GET['id_product']) AND Validate::isUnsignedId($_GET['id_product'])) {
					$IdCategoryProduct = $this->getCategoryProduct($_GET['id_product']);
					$SpecialPageCategoryBlock = $this->getSpecialListTpl($cookie->id_lang, $IdCategoryProduct[0]['id_category']);
					if(count($SpecialPageCategoryBlock)>0) {
						$IdPageTpl = ($SpecialPageCategoryBlock[0]['display']!='always') ? $SpecialPageCategoryBlock[0]['id_page'] : -1;
						if($SpecialPageCategoryBlock[0]['mode']=='confirm') $SpecialPageCategoryBlock[0]['tempsaffichage'] = 3600000 ;
						if(intval($IdPageTpl)!=999999999) {
							$smarty->assign(array(
								'colorBackground' => $SpecialPageCategoryBlock[0]['color'],
								'colorPopup' => $SpecialPageCategoryBlock[0]['colorpopup'],
								'widthBox' => $SpecialPageCategoryBlock[0]['width'],
								'heightBox' => $SpecialPageCategoryBlock[0]['height'],
								'positionLeftBox' => (($SpecialPageCategoryBlock[0]['width']/2) * -1),
								'positionTopBox' => (($SpecialPageCategoryBlock[0]['height']/2)*-1),
								'positionLeftClose' => ($SpecialPageCategoryBlock[0]['width']/2)-16,
								'heightTextBox' => $SpecialPageCategoryBlock[0]['height']-25,
								'opaciteBackground' => $SpecialPageCategoryBlock[0]['opacity'],
								'descriptionBox' => $SpecialPageCategoryBlock[0]['description'], 
								'dureeCookieHeure' => $SpecialPageCategoryBlock[0]['viecookieheure'],
								'dureeCookieMin' => $SpecialPageCategoryBlock[0]['viecookieminute'],
								'imgfond' => $SpecialPageCategoryBlock[0]['imgfond'],
								'mode' => $SpecialPageCategoryBlock[0]['mode'],
								'url_retour' => $SpecialPageCategoryBlock[0]['url_retour'],
								'click_out' => $SpecialPageCategoryBlock[0]['click_out'],
								'tempsaffichage' => $SpecialPageCategoryBlock[0]['tempsaffichage'],
								'jsIdPage' => $IdPageTpl
							));
							return $this->display(__FILE__, 'dommessagecategory.tpl');
						}
					}
				}	
			}		
		}
	}
}

?>
